DEFAULT_LAT = 0;
DEFAULT_LON = 0;
DEFAULT_ZOOM = 14;
function GPXParser(xmlDoc, map) {
this.xmlDoc = xmlDoc;
this.map = map;
this.trackcolour = "#ff00ff";
this.trackwidth = 5;
this.mintrackpointdelta = 0;
this.startTime = null;
this.endTime = null;
this.filename = null;
this.polylineArr = [];
}
GPXParser.prototype.setFileName = function(name) {
this.filename = name;
}
GPXParser.prototype.setTrackColour = function(colour) {
this.trackcolour = colour;
}
GPXParser.prototype.setTrackWidth = function(width) {
this.trackwidth = width;
}
GPXParser.prototype.setMinTrackPointDelta = function(delta) {
this.mintrackpointdelta = delta;
}
GPXParser.prototype.calculateDistance = function(lat1, lon1, lat2, lon2) {
var radlat1 = Math.PI * lat1/180;
var radlat2 = Math.PI * lat2/180;
var theta = lon1 - lon2;
var radtheta = Math.PI * theta/180;
var dist = Math.sin(radlat1) * Math.sin(radlat2) + Math.cos(radlat1) * Math.cos(radlat2) * Math.cos(radtheta);
dist = Math.acos(dist) * 6371000;
return dist; // Unit: m
}
GPXParser.prototype.addTrackSegmentToMap = function(trackSegment, colour, width) {
var trackpoints = trackSegment.getElementsByTagName("trkpt");
if(trackpoints.length == 0) return; // No valid data
var pointarray = [];
var lastlon = parseFloat(trackpoints[0].getAttribute("lon"));
var lastlat = parseFloat(trackpoints[0].getAttribute("lat"));
var latlng = new google.maps.LatLng(lastlat,lastlon);
var start_marker = this.addMarker(latlng,GetElmCont("gnss_0","Start").charAt(0),GetElmCont("gnss_0","Start position")); // Eric: Show the start point
if(!this.startTime) {
this.startTime = new Date(trackpoints[0].getElementsByTagName("time").item(0).childNodes[0].nodeValue);
}
pointarray.push(latlng);
for(var i = 1; i < trackpoints.length; i++) {
var lon = parseFloat(trackpoints[i].getAttribute("lon"));
var lat = parseFloat(trackpoints[i].getAttribute("lat"));
var distance = this.calculateDistance(lat, lon, lastlat, lastlon);
if(distance > this.mintrackpointdelta) {
lastlon = lon;
lastlat = lat;
latlng = new google.maps.LatLng(lat,lon);
pointarray.push(latlng);
}
}
var end_marker = this.addMarker(latlng,GetElmCont("gnss_0","End").charAt(0),GetElmCont("gnss_0","End position")); // Eric: Show the end point
this.endTime = new Date(trackpoints[trackpoints.length-1].getElementsByTagName("time").item(0).childNodes[0].nodeValue);
var polyline = new google.maps.Polyline({
path: pointarray,
strokeColor: colour,
strokeWeight: width,
map: this.map
});
this.polylineArr.push({start: start_marker, end: end_marker, line: polyline}); // store start_marker, end_marker, and polyline
}
GPXParser.prototype.addTrackToMap = function(track, colour, width) {
var segments = track.getElementsByTagName("trkseg");
for(var i = 0; i < segments.length; i++) {
var segmentlatlngbounds = this.addTrackSegmentToMap(segments[i], colour, width);
}
}
GPXParser.prototype.centerAndZoom = function(trackSegment) {
var minlat = 0;
var maxlat = 0;
var minlon = 0;
var maxlon = 0;
var bound = trackSegment.getElementsByTagName("bounds");
if(bound.length > 0) {
minlat = parseFloat(bound[0].getAttribute("minlat"));
minlon = parseFloat(bound[0].getAttribute("minlon"));
maxlat = parseFloat(bound[0].getAttribute("maxlat"));
maxlon = parseFloat(bound[0].getAttribute("maxlon"));
}
if(!minlat || !minlon || !maxlat || !maxlon) {
var pointlist = new Array("trkpt", "wpt");
for(var pointtype = 0; pointtype < pointlist.length; pointtype++) {
var trackpoints = trackSegment.getElementsByTagName(
pointlist[pointtype]);
if((trackpoints.length > 0) && (minlat == maxlat) && (minlat == 0)) {
minlat = parseFloat(trackpoints[0].getAttribute("lat"));
maxlat = parseFloat(trackpoints[0].getAttribute("lat"));
minlon = parseFloat(trackpoints[0].getAttribute("lon"));
maxlon = parseFloat(trackpoints[0].getAttribute("lon"));
}
for(var i = 0; i < trackpoints.length; i++) {
var lon = parseFloat(trackpoints[i].getAttribute("lon"));
var lat = parseFloat(trackpoints[i].getAttribute("lat"));
if(lon < minlon) minlon = lon;
if(lon > maxlon) maxlon = lon;
if(lat < minlat) minlat = lat;
if(lat > maxlat) maxlat = lat;
}
}
if((minlat == maxlat) && (minlat == 0)) { // no valid data, set default position as center
this.map.setZoom(DEFAULT_ZOOM); // zoom the map to large scale
this.map.setCenter({lat: DEFAULT_LAT, lng: DEFAULT_LON }); // set center at current location
return;
}
}
if(minlon > maxlon || minlat > maxlat) return; // wrong boundary
var centerlon = (maxlon + minlon) / 2;
var centerlat = (maxlat + minlat) / 2;
var bounds = new google.maps.LatLngBounds(
new google.maps.LatLng(minlat, minlon),
new google.maps.LatLng(maxlat, maxlon));
this.map.setCenter(new google.maps.LatLng(centerlat, centerlon));
this.map.fitBounds(bounds);
}
GPXParser.prototype.centerAndZoomToLatLngBounds = function(latlngboundsarray) {
var boundingbox = new google.maps.LatLngBounds();
for(var i = 0; i < latlngboundsarray.length; i++) {
if(!latlngboundsarray[i].isEmpty()) {
boundingbox.extend(latlngboundsarray[i].getSouthWest());
boundingbox.extend(latlngboundsarray[i].getNorthEast());
}
}
var centerlat = (boundingbox.getNorthEast().lat() +
boundingbox.getSouthWest().lat()) / 2;
var centerlng = (boundingbox.getNorthEast().lng() +
boundingbox.getSouthWest().lng()) / 2;
this.map.setCenter(new google.maps.LatLng(centerlat, centerlng),
this.map.getBoundsZoomLevel(boundingbox));
}
GPXParser.prototype.addTrackpointsToMap = function() {
var tracks = this.xmlDoc.documentElement.getElementsByTagName("trk");
for(var i = 0; i < tracks.length; i++) {
this.addTrackToMap(tracks[i], this.trackcolour, this.trackwidth);
}
}
GPXParser.prototype.addMarker = function(latlng, labelstr, titlestr) {
var marker = new google.maps.Marker({
position: latlng,
map: this.map,
label: labelstr,
title: titlestr
});
return marker;
}
GPXParser.prototype.clearMap = function() {
var i;
for(i = this.polylineArr.length - 1; i >= 0 ; --i) {
this.polylineArr[i].start.setMap(null);
this.polylineArr[i].end.setMap(null);
this.polylineArr[i].line.setMap(null);
this.polylineArr.splice(i, 1); // remove the elements from array
}
}